<?php

namespace App\Http\Controllers\Website;

use App\Enums\SectionType;
use App\Helper\Media;
use App\Http\Controllers\Controller;
use App\Models\AboutUs;
use App\Models\Album;
use App\Models\Blog;
use App\Models\Category;
use App\Models\Partener;
use App\Models\Phone;
use App\Models\Project;
use App\Models\Section;
use App\Models\Service;
use App\Models\SiteAddress;
use App\Models\Slider;
use App\Models\Team;
use App\Models\Testimonial;
use App\Services\Seo\SeoService;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {
        $data['sliders'] = Slider::type('home')->active()->get();
        $data['about'] = AboutUs::first();

        $data['categories'] = Category::with('products')->whereHas('products', function ($query) {
            $query->active()->home()->orderBy('order');
        })->active()->get();

        $data['services'] = Service::whereNull('parent_id')
                    ->active()
                    ->home()
                    ->orderBy('order')
                    ->take(6)
                    ->get();


      
        $data['certificates'] = Album::with('images')->type('certificate')->active()->orderBy('order')->get();
        $data['projects'] = Project::with('images')->active()->home()->orderBy('order')->take(3)->get();
        $data['blogs'] = Blog::with('category')->active()->home()->orderBy('order')->take(3)->get();
        $data['albums'] = Album::with('images')->active()->whereNull('type')->orderBy('order')->take(6)->get();

    
        $data['products_section'] = Section::type(SectionType::PRODUCTS)->first();
        $data['cta_section'] = Section::type(SectionType::CTA)->first();
        $data['projects_section'] = Section::type(SectionType::PROJECTS)->first();
        $data['testimonials_section'] = Section::type(SectionType::TESTIMONIALS)->first();
        $data['certificates_section'] = Section::type(SectionType::CERTIFICATES)->first();
        $data['services_section'] = Section::type(SectionType::SERVICES)->first();



        
      
        $data['contact_section'] = Section::type(\App\Enums\SectionType::CONTACT_SECTION)->first();

        $data['appointment_section'] = Section::where('key', 'appointment_section')->first();

        $data['projects'] = Project::with('images')->active()->home()->orderBy('order')->get();

      

        $data['doctors'] = Team::active()->orderBy('order')->get();
        $data['doctors_section'] = Section::where('key', 'doctors_section')->first();
        $data['testimonials'] = Testimonial::active()->get();
      
        $data['partners'] = Partener::active()->get();
        $data['partners_section'] = Section::where('key', 'partners_section')->first();

        $data['blogs_section'] = Section::where('key', 'blogs_section')->first();

        $data['site_addresses'] = SiteAddress::active()->orderBy('order')->get();
        $data['phones'] = Phone::active()->get();

        $seoService = new SeoService;
        $data['seoHandler'] = $seoService->forHome();

        return view('Website.home', $data);
    }
}
