<?php

namespace App\Http\Requests\Dashboard\Statistics;

use Illuminate\Foundation\Http\FormRequest;

class StoreStatisticRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'title_en' => 'nullable|string|max:255',
            'title_ar' => 'nullable|string|max:255',
            'value' => 'nullable|numeric',
            'text_en' => 'nullable|string',
            'text_ar' => 'nullable|string',
            'icon' => 'nullable|image|mimes:jpeg,png,gif,bmp,webp,svg|max:1024',
            'alt_icon' => 'nullable|string|max:255',
            'status' => 'nullable|boolean',
        ];
    }
}
