<x-website.layout :seoHandler="$seoHandler ?? ''">
    <!-- start banner -->
    @include('Website.partials._breadcrumb', ['page_title' => $category->name])
    <!-- end banner -->

    <!-- start service details -->
    <section class="whychoous-1-section pt_150">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="whychoous-1-bg"
                        style="
                  background-image: url({{ Path::imagesPath('background/pattern.png') }});
                ">
                    </div>
                    <div class="whychoous-1-small-container">
                        <div class="section_heading mb_40">
                            <h2 class="section_heading_title_big c_light mb_20">
                                {{ $category->name }}
                            </h2>
                            <p>
                              
                                {!! $category->long_desc !!}
                            </p>
                            <img src="{{ $category->image_path }}" alt="{{ $category->alt_image }}" />
                        </div>
                    </div>
                </div>
                @if ($category->images->isNotEmpty())
                <div class="col-md-6">
                    <div class="whychoous-1-small-container p_relative">
                        <div class="swiper-container three-item-carousel">
                            <div class="swiper-wrapper">
                                <!-- Slide Item -->
                                @foreach ($category->images as $image)
                                    <div class="swiper-slide">
                                        <img src="{{ $image->image_path }}" alt="{{ $image->alt_image }}" />
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="slider-nav-style-1 alt">
                            <div class="slider-control slider-button-prev">
                                <span></span>
                            </div>
                            <div class="slider-control slider-button-next">
                                <span></span>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </section>
    <!-- end service details -->
</x-website.layout>
