<section class="product-1-section pt_100 pb_70">
    <div class="auto-container">
        <div class="section_heading text-center mb_60">
            <span class="section_heading_title_small">{{ $products_section?->title }}</span>
            <h2 class="section_heading_title_big">{{ $products_section?->second_title }}</h2>
        </div>
        @foreach ($categories as $category)
            @if ($category->products->count() > 0)
                <div class="category-section mb_60">
                    <div class="category-title text-center mb_40">
                        <h3 class="category-heading">{{ $category->name }}</h3>
                    </div>

                    <div class="swiper-container four-item-carousel category-products-{{ $category->id }}">
                        <div class="swiper-wrapper">
                            @foreach ($category->products as $product)
                                <div class="swiper-slide">
                                    <div class="product-1-block mb_30">
                                        <div class="product-1-thumb">
                                            <img src="{{ $product->image_path }}" alt="{{ $product->name }}">
                                        </div>
                                        <h4 class="product-1-title">{{ $product->name }}</h4>
                                        <div class="link-btn"><a href="{{ $product->link }}"
                                                class="btn-1 btn-small alt">@lang('website.read_more') <span></span></a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="mt_40"></div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
                <div class="link-btn text-center mt_30 mb_30">
                    <a href="{{ route('website.categoryDetails', $category) }}" class="btn-1">
                        {{ __('website.more_products') }}
                        <span></span>
                    </a>
                </div>
            @endif
        @endforeach
        {{-- <div class="link-btn text-center mt_30 mb_30"><a href="{{ route('website.categories') }}" class="btn-1">
                {{ __('website.more_products') }}
                <span></span></a></div> --}}

    </div>
</section>
