<form method="post" action="{{ route('website.contact-us') }}" id="contact-form">
    @csrf
    <div class="row row-20 clearfix">
        <div class="form-group col-md-12">
            <input type="text" name="name" value="{{ old('name') }}" placeholder="Your Name" required="">
            @error('name')
                <span class="text-danger">{{ $message }}</span>
            @enderror
        </div>
        
        <div class="form-group col-md-12">
            <input type="email" name="email" value="{{ old('email') }}" placeholder="Your Email" required="">
            @error('email')
                <span class="text-danger">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group col-md-12">
            <input type="text" name="phone" value="{{ old('phone') }}" placeholder="Phone Number" required="">
            @error('phone') 
                <span class="text-danger">{{ $message }}</span>
            @enderror
        </div>

        

        <div class="form-group col-md-12">
            <select id="nice-select" name="service_id">
                @foreach ($services as $service)
                    <option value="{{ $service->id }}">{{ $service->name }}</option>
                @endforeach
            </select>
            @error('service_id')
                <span class="text-danger">{{ $message }}</span>
            @enderror
        </div>

 
        
        
        <div class="form-group col-md-12">
           
            <button class="btn-1" type="submit" data-loading-text="Please wait...">Submit Request <i class="flaticon-right-arrow-1"></i><span style="top: -5.29688px; left: 21.9688px;"></span></button>
        </div>
    </div>
</form>