<x-website.layout :seoHandler="$seoHandler ?? ''">
    <!-- start banner -->
    @include('Website.partials._breadcrumb', ['page_title' => $product->name])
    <!-- end banner -->

    <!-- start service details -->
    <section class="whychoous-1-section pt_150">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="whychoous-1-bg"
                        style="
                  background-image: url({{ Path::imagesPath('background/pattern.png') }});
                ">
                    </div>
                    <div class="whychoous-1-small-container">
                        <div class="section_heading mb_40">
                            <h2 class="section_heading_title_big c_light mb_20">
                                {{ $product->name }}
                            </h2>
                            <p class="c_light">
                                {{ $product->short_desc }}
                            </p>
                            <img src="{{ $product->image_path }}" alt="{{ $product->alt_image }}" />
                        </div>
                    </div>
                </div>
                @if ($product->images->isNotEmpty())
                <div class="col-md-6">
                    <div class="whychoous-1-small-container p_relative">
                        <div class="swiper-container three-item-carousel">
                            <div class="swiper-wrapper">
                                <!-- Slide Item -->
                                @foreach ($product->images as $image)
                                    <div class="swiper-slide">
                                        <img src="{{ $image->image_path }}" alt="{{ $image->alt_image }}" />
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="slider-nav-style-1 alt">
                            <div class="slider-control slider-button-prev">
                                <span></span>
                            </div>
                            <div class="slider-control slider-button-next">
                                <span></span>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </section>
    <!-- end service details -->


    <section class="pricing-style-two pt_150 pb_100">
        <div class="auto-container">
            <div class="pricing-table">
                <table class="table-outer">
                    <thead class="table-header">
                        <tr>
                            <th>Dimensions</th>
                            <th>Price</th>
                            <th>PDF</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>3,50m x 1,80m x 1,00m</td>
                            <td>99.00 LE</td>
                            <td>
                                <a href="assets/files/example.pdf" download="example.pdf"><i
                                        class="fa-solid fa-download"></i>Download</a>
                            </td>
                        </tr>
                        <tr>
                            <td>3,50m x 1,80m x 1,00m</td>
                            <td>99.00 LE</td>
                            <td>
                                <a href="assets/files/example.pdf" download="example.pdf"><i
                                        class="fa-solid fa-download"></i>Download</a>
                            </td>
                        </tr>
                        <tr>
                            <td>3,50m x 1,80m x 1,00m</td>
                            <td>99.00 LE</td>
                            <td>
                                <a href="assets/files/example.pdf" download="example.pdf"><i
                                        class="fa-solid fa-download"></i>Download</a>
                            </td>
                        </tr>
                        <tr>
                            <td>3,50m x 1,80m x 1,00m</td>
                            <td>99.00 LE</td>
                            <td>
                                <a href="assets/files/example.pdf" download="example.pdf"><i
                                        class="fa-solid fa-download"></i>Download</a>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </section>


    <section class="core-section pt_100 pb_100">
        <div class="auto-container">
            <div class="row">



                <p class="mb_30">
                    {!! $product->long_desc !!}
                </p>



            </div>
        </div>
    </section>


    <section class="pt_100 gray-bg p_relative">
        <div class="auto-container">
            <div class="row">
                <div class="col-lg-12 p_relative">
                    <div class="section_heading mb_60">
                        <h2 class="section_heading_title_big mb_20">{{ __('website.contact_us') }}</h2>
                    </div>
                    <div class="form-1-wrap">
                        @include('Website.partials._contact-form', ['services' => $services])
                    </div>
                </div>
            </div>
        </div>
    </section>

</x-website.layout>
