<x-website.layout :seoHandler="$seoHandler ?? ''">

    <!-- start banner -->
    @include('Website.partials._breadcrumb', ['page_title' => __('website.products')])
    <!-- end banner -->
    @if ($products->isNotEmpty())
    <section class="service-page-section pt_150 gray-bg">
        <div class="auto-container">
            <div class="inner-container">
                <div class="row clearfix">
                    @foreach ($products as $product)
                        <div class="col-lg-3 col-md-6 col-sm-12 service-block">
                            <div class="service-1-block text-center wow fadeInLeft" data-wow-delay=".2s"
                                data-wow-duration=".8s">
                                <div class="service-1-image hvr-img-zoom-1">
                                    <img src="{{ $product->image_path }}" alt="{{ $product->name }}" />
                                </div>
                                <div class="service-1-link">
                                    <a class="service-1-link-btn hvr-zoom-1 hvr-zoom-1-primary"
                                        href="{{ route('website.productDetails', $product) }}"><i
                                            class="icon-6"></i></a>
                                </div>
                                <h4 class="service-1-title">{{ $product->name }}</h4>
                                <div class="service-1-block-overlay text-center">
                                    <div class="service-1-link">
                                        <a class="service-1-link-btn hvr-zoom-1 hvr-zoom-1-primary"
                                            href="{{ route('website.productDetails', $product) }}"><i
                                                class="icon-3"></i></a>
                                    </div>
                                    <h4 class="service-1-title">{{ $product->name }}</h4>
                                    <p class="service-1-text">
                                        {{ $product->short_desc }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
    @endif

    <section class="pt_150 gray-bg p_relative">
        <div class="auto-container">
            <div class="row">
                <div class="col-lg-6 p_relative">
                    <div class="section_heading mb_60">
                        <h2 class="section_heading_title_big mb_20">{{ __('website.contact_us') }}</h2>
                    </div>
                    <div class="form-1-wrap">
                        @include('Website.partials._contact-form')
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="map">
                        <iframe src="{{ $settings['site_map'] }}" width="100%" height="550" style="border: 0"
                            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </section>

</x-website.layout>
