$('#btn_active').click(function() {
    var selectedCheckboxes = $(".check-inputs:checked");

    var selectedIds = [];

    selectedCheckboxes.each(function() {
        selectedIds.push($(this).val());
    });

    if (selectedIds.length === 0) {
        Swal.fire({
            title: "<?php echo app('translator')->get('messages.no_select'); ?>?"
            , text: "<?php echo app('translator')->get('messages.please select at least one'); ?>"
            , icon: "warning"
            , confirmButtonColor: "#5156be"
        });
    } else {

        Swal.fire({
            title: "<?php echo app('translator')->get('messages.are you sure?'); ?>"
            , text: "<?php echo app('translator')->get('messages.change checked status'); ?>"
            , icon: "warning"
            , showCancelButton: true
            , confirmButtonColor: "#3085d6"
            , cancelButtonColor: "#d33"
            , confirmButtonText: "<?php echo app('translator')->get('messages.yes, change it'); ?>!"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: url + "/change-status" + '/' + selectedIds
                    , type: 'POST'
                    , data: {
                        selectedIds: selectedIds
                        , modelName: segment
                    }
                    , success: function(response) {
                        if (response.success) {

                            // Reload the page to reflect the changes
                            location.reload();
                        } else {
                            Swal.fire({
                                icon: "error"
                                , title: "Error!"
                                , text: response.message
                                , showConfirmButton: false
                                , timer: 5500
                            });
                        }
                    }
                    , error: function(error) {
                        Swal.fire({
                            title: "Error!"
                            , text: error.responseJSON.message
                            , icon: "error"
                        });
                    }
                });
            }
        });
    }

});<?php /**PATH /home/aquamenam/public_html/new/resources/views/components/dashboard/partials/change-status.blade.php ENDPATH**/ ?>